/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

class Buffer {
    static final int NO_LENGTH_LIMIT = -1;
    static final long NULL_LENGTH = -1L;
    private byte[] byteBuffer;
    private boolean wasMultiPacket = false;
    private int bufLength = 0;
    private int position = 0;
    private int sendLength = 0;

    Buffer(byte[] buf) {
        this.byteBuffer = buf;
        this.setBufLength(buf.length);
    }

    Buffer(int size) {
        this.byteBuffer = new byte[size];
        this.setBufLength(this.byteBuffer.length);
        this.position = 4;
    }

    public void setByteBuffer(byte[] byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setWasMultiPacket(boolean flag) {
        this.wasMultiPacket = flag;
    }

    public int fastSkipLenString() {
        long len = this.readFieldLength();
        this.position = (int)((long)this.position + len);
        return (int)len;
    }

    public boolean wasMultiPacket() {
        return this.wasMultiPacket;
    }

    protected final byte[] getBufferSource() {
        return this.byteBuffer;
    }

    final byte[] getBytes(int len) {
        byte[] b2 = new byte[len];
        System.arraycopy(this.byteBuffer, this.position, b2, 0, len);
        this.position += len;
        return b2;
    }

    final boolean isLastDataPacket() {
        return this.getBufLength() < 9 && (this.byteBuffer[0] & 0xFF) == 254;
    }

    final void clear() {
        this.position = 4;
    }

    final void dump() {
        StringUtils.dumpAsHex(this.byteBuffer, this.getBufLength());
    }

    final void dumpHeader() {
        int i2 = 0;
        while (i2 < 4) {
            String hexVal = Integer.toHexString(this.byteBuffer[i2] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(hexVal + " ");
            ++i2;
        }
    }

    final void dumpNBytes(int start, int nBytes) {
        StringBuffer asciiBuf = new StringBuffer();
        int i2 = start;
        while (i2 < start + nBytes && i2 < this.byteBuffer.length) {
            String hexVal = Integer.toHexString(this.byteBuffer[i2] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(hexVal + " ");
            if (this.byteBuffer[i2] > 32 && this.byteBuffer[i2] < 127) {
                asciiBuf.append((char)this.byteBuffer[i2]);
            } else {
                asciiBuf.append(".");
            }
            asciiBuf.append(" ");
            ++i2;
        }
        System.out.println("    " + asciiBuf.toString());
    }

    final void ensureCapacity(int additionalData) throws SQLException {
        if (this.position + additionalData > this.getBufLength()) {
            if (this.position + additionalData < this.byteBuffer.length) {
                this.setBufLength(this.byteBuffer.length);
            } else {
                int newLength = (int)((double)this.byteBuffer.length * 1.25);
                if (newLength < this.byteBuffer.length + additionalData) {
                    newLength = this.byteBuffer.length + (int)((double)additionalData * 1.25);
                }
                if (newLength < this.byteBuffer.length) {
                    newLength = this.byteBuffer.length + additionalData;
                }
                byte[] newBytes = new byte[newLength];
                System.arraycopy(this.byteBuffer, 0, newBytes, 0, this.byteBuffer.length);
                this.byteBuffer = newBytes;
                this.setBufLength(this.byteBuffer.length);
            }
        }
    }

    final long newReadLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return sw;
    }

    final byte readByte() {
        return this.byteBuffer[this.position++];
    }

    final long readFieldLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return -1L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return sw;
    }

    final int readInt() {
        byte[] b2 = this.byteBuffer;
        return b2[this.position++] & 0xFF | (b2[this.position++] & 0xFF) << 8;
    }

    final byte[] readLenByteArray(int offset) {
        long len = this.readFieldLength();
        if (len == -1L) {
            return null;
        }
        if (len == 0L) {
            return new byte[0];
        }
        this.position += offset;
        return this.getBytes((int)len);
    }

    final long readLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return sw;
    }

    final long readLong() {
        byte[] b2 = this.byteBuffer;
        return b2[this.position++] & 0xFF | (b2[this.position++] & 0xFF) << 8 | (b2[this.position++] & 0xFF) << 16 | (b2[this.position++] & 0xFF) << 24;
    }

    final int readLongInt() {
        byte[] b2 = this.byteBuffer;
        return b2[this.position++] & 0xFF | (b2[this.position++] & 0xFF) << 8 | (b2[this.position++] & 0xFF) << 16;
    }

    final long readLongLong() {
        byte[] b2 = this.byteBuffer;
        return (long)(b2[this.position++] & 0xFF) | (long)(b2[this.position++] & 0xFF) << 8 | (long)(b2[this.position++] & 0xFF) << 16 | (long)(b2[this.position++] & 0xFF) << 24 | (long)(b2[this.position++] & 0xFF) << 32 | (long)(b2[this.position++] & 0xFF) << 40 | (long)(b2[this.position++] & 0xFF) << 48 | (long)(b2[this.position++] & 0xFF) << 56;
    }

    final String readString() {
        int i2 = this.position;
        int len = 0;
        int maxLen = this.getBufLength();
        while (i2 < maxLen && this.byteBuffer[i2] != 0) {
            ++len;
            ++i2;
        }
        String s2 = new String(this.byteBuffer, this.position, len);
        this.position += len + 1;
        return s2;
    }

    final String readString(String encoding) throws SQLException {
        int i2 = this.position;
        int len = 0;
        int maxLen = this.getBufLength();
        while (i2 < maxLen && this.byteBuffer[i2] != 0) {
            ++len;
            ++i2;
        }
        this.position += len + 1;
        try {
            return new String(this.byteBuffer, this.position, len, encoding);
        }
        catch (UnsupportedEncodingException uEE) {
            throw new SQLException("Unsupported character encoding '" + encoding + "'", "S1009");
        }
    }

    final int readnBytes() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 1: {
                return this.byteBuffer[this.position++] & 0xFF;
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    final void writeByte(byte b2) throws SQLException {
        this.ensureCapacity(1);
        this.byteBuffer[this.position++] = b2;
    }

    final void writeBytesNoNull(byte[] bytes) throws SQLException {
        int len = bytes.length;
        this.ensureCapacity(len);
        System.arraycopy(bytes, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    final void writeBytesNoNull(byte[] bytes, int offset, int length) throws SQLException {
        this.ensureCapacity(length);
        System.arraycopy(bytes, offset, this.byteBuffer, this.position, length);
        this.position += length;
    }

    final void writeDouble(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        this.writeLongLong(l2);
    }

    final void writeFloat(float f2) {
        int i2 = Float.floatToIntBits(f2);
        byte[] b2 = this.byteBuffer;
        b2[this.position++] = (byte)(i2 & 0xFF);
        b2[this.position++] = (byte)(i2 >>> 8);
        b2[this.position++] = (byte)(i2 >>> 16);
        b2[this.position++] = (byte)(i2 >>> 24);
    }

    final void writeInt(int i2) {
        byte[] b2 = this.byteBuffer;
        b2[this.position++] = (byte)(i2 & 0xFF);
        b2[this.position++] = (byte)(i2 >>> 8);
    }

    final void writeLong(long i2) {
        byte[] b2 = this.byteBuffer;
        b2[this.position++] = (byte)(i2 & 0xFFL);
        b2[this.position++] = (byte)(i2 >>> 8);
        b2[this.position++] = (byte)(i2 >>> 16);
        b2[this.position++] = (byte)(i2 >>> 24);
    }

    final void writeLongInt(int i2) {
        byte[] b2 = this.byteBuffer;
        b2[this.position++] = (byte)(i2 & 0xFF);
        b2[this.position++] = (byte)(i2 >>> 8);
        b2[this.position++] = (byte)(i2 >>> 16);
    }

    final void writeLongLong(long i2) {
        byte[] b2 = this.byteBuffer;
        b2[this.position++] = (byte)(i2 & 0xFFL);
        b2[this.position++] = (byte)(i2 >>> 8);
        b2[this.position++] = (byte)(i2 >>> 16);
        b2[this.position++] = (byte)(i2 >>> 24);
        b2[this.position++] = (byte)(i2 >>> 32);
        b2[this.position++] = (byte)(i2 >>> 40);
        b2[this.position++] = (byte)(i2 >>> 48);
        b2[this.position++] = (byte)(i2 >>> 56);
    }

    final void writeString(String s2) throws SQLException {
        this.ensureCapacity(s2.length() + 1);
        this.writeStringNoNull(s2);
        this.byteBuffer[this.position++] = 0;
    }

    final void writeStringNoNull(String s2) throws SQLException {
        int len = s2.length();
        this.ensureCapacity(len);
        System.arraycopy(s2.getBytes(), 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    final void writeStringNoNull(String s2, String encoding, SingleByteCharsetConverter converter, boolean parserKnowsUnicode) throws UnsupportedEncodingException, SQLException {
        byte[] b2 = null;
        b2 = converter != null ? converter.toBytes(s2) : StringUtils.getBytes(s2, encoding, parserKnowsUnicode);
        int len = b2.length;
        this.ensureCapacity(len);
        System.arraycopy(b2, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    void setBufLength(int bufLength) {
        this.bufLength = bufLength;
    }

    int getBufLength() {
        return this.bufLength;
    }

    void setSendLength(int sendLength) {
        this.sendLength = sendLength;
    }

    static {
        NO_LENGTH_LIMIT = -1;
        NULL_LENGTH = -1L;
    }
}

