/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Blob;
import com.mysql.jdbc.Clob;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.NotUpdatable;
import com.mysql.jdbc.ResultSetMetaData;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ResultSet
implements java.sql.ResultSet {
    private TimeZone defaultTimeZone;
    protected Connection connection;
    protected Map columnNameToIndex = null;
    protected Map fullColumnNameToIndex = null;
    protected RowData rowData;
    protected SQLWarning warningChain = null;
    protected Statement owningStatement;
    protected String catalog = null;
    protected String serverInfo = null;
    protected Field[] fields;
    protected byte[][] thisRow;
    protected boolean doingUpdates = false;
    protected boolean isClosed = false;
    protected boolean onInsertRow = false;
    protected boolean reallyResult = false;
    protected boolean wasNullFlag = false;
    protected char firstCharOfQuery;
    protected int currentRow = -1;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected int resultSetConcurrency = 0;
    protected int resultSetType = 0;
    protected long updateCount;
    protected long updateId = -1L;
    private Calendar fastDateCal = null;
    private boolean hasBuiltIndexMapping = false;
    private boolean useStrictFloatingPoint = false;

    public ResultSet(long updateCount, long updateID) {
        this.updateCount = updateCount;
        this.updateId = updateID;
        this.reallyResult = false;
        this.fields = new Field[0];
    }

    public ResultSet(String catalog, Field[] fields, RowData tuples, Connection conn) throws SQLException {
        this(fields, tuples);
        this.setConnection(conn);
        this.catalog = catalog;
    }

    public ResultSet(Field[] fields, RowData tuples) throws SQLException {
        this.fields = fields;
        this.rowData = tuples;
        this.updateCount = this.rowData.size();
        this.reallyResult = true;
        if (this.rowData.size() > 0) {
            if (this.updateCount == 1L && this.thisRow == null) {
                this.rowData.close();
                this.updateCount = -1L;
            }
        } else {
            this.thisRow = null;
        }
        this.rowData.setOwner(this);
    }

    public boolean isAfterLast() throws SQLException {
        boolean b2 = this.rowData.isAfterLast();
        return b2;
    }

    public Array getArray(int i2) throws SQLException {
        throw new NotImplemented();
    }

    public Array getArray(String colName) throws SQLException {
        throw new NotImplemented();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        boolean b2 = this.rowData.isBeforeFirst();
        return b2;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String stringVal = this.getString(columnIndex);
        if (stringVal != null) {
            BigDecimal val2;
            if (stringVal.length() == 0) {
                BigDecimal val2 = new BigDecimal(0.0);
                return val2.setScale(scale);
            }
            try {
                val2 = new BigDecimal(stringVal);
            }
            catch (NumberFormatException ex) {
                throw new SQLException("Bad format for BigDecimal '" + stringVal + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
            }
            try {
                return val2.setScale(scale);
            }
            catch (ArithmeticException ex) {
                throw new SQLException("Bad format for BigDecimal '" + stringVal + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
            }
        }
        return null;
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        if (stringVal != null) {
            if (stringVal.length() == 0) {
                BigDecimal val = new BigDecimal(0.0);
                return val;
            }
            try {
                BigDecimal val = new BigDecimal(stringVal);
                return val;
            }
            catch (NumberFormatException ex) {
                throw new SQLException("Bad format for BigDecimal '" + stringVal + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
            }
        }
        return null;
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        byte[] b2 = this.getBytes(columnIndex);
        if (b2 != null) {
            return new ByteArrayInputStream(b2);
        }
        return null;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public java.sql.Blob getBlob(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
        }
        catch (NullPointerException ex) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return null;
        }
        return new Blob(this.thisRow[columnIndex - 1]);
    }

    public java.sql.Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        if (stringVal != null && stringVal.length() > 0) {
            char c2 = Character.toLowerCase(stringVal.charAt(0));
            return c2 == 't' || c2 == 'y' || c2 == '1' || stringVal.equals("-1");
        }
        return false;
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.checkRowPos();
        try {
            this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
        }
        catch (NullPointerException E) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return 0;
        }
        Field field = this.fields[columnIndex - 1];
        switch (field.getMysqlType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                try {
                    String stringVal = this.getString(columnIndex);
                    int decimalIndex = stringVal.indexOf(".");
                    if (decimalIndex != -1) {
                        stringVal = stringVal.substring(0, decimalIndex);
                    }
                    return Byte.parseByte(stringVal);
                }
                catch (NumberFormatException NFE) {
                    throw new SQLException("Value '" + this.getString(columnIndex) + "' is out of range [-127,127]", "S1009");
                }
            }
        }
        try {
            String stringVal = this.getString(columnIndex);
            int decimalIndex = stringVal.indexOf(".");
            if (decimalIndex != -1) {
                stringVal = stringVal.substring(0, decimalIndex);
            }
            return Byte.parseByte(stringVal);
        }
        catch (NumberFormatException NFE) {
            throw new SQLException("Value '" + this.getString(columnIndex) + "' is out of range [-127,127]", "S1009");
        }
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkRowPos();
        try {
            this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
        }
        catch (NullPointerException E) {
            this.wasNullFlag = true;
        }
        catch (ArrayIndexOutOfBoundsException aioobEx) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.fields.length + ").", "S1002");
        }
        if (this.wasNullFlag) {
            return null;
        }
        return this.thisRow[columnIndex - 1];
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        if (stringVal != null) {
            return new StringReader(stringVal);
        }
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public java.sql.Clob getClob(int i2) throws SQLException {
        return new Clob(this.getString(i2));
    }

    public java.sql.Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public synchronized void setConnection(Connection conn) {
        this.connection = conn;
        if (this.connection != null) {
            this.useStrictFloatingPoint = this.connection.useStrictFloatingPoint();
            this.defaultTimeZone = this.connection.getDefaultTimeZone();
        } else {
            this.defaultTimeZone = TimeZone.getDefault();
        }
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned Update not supported.", "S1C00");
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Integer year = null;
        Integer month = null;
        Integer day = null;
        String stringVal = "";
        try {
            stringVal = this.getString(columnIndex);
            if (stringVal == null) {
                return null;
            }
            int length = stringVal.length();
            if (length > 0 && stringVal.charAt(0) == '0' && (stringVal.equals("0000-00-00") || stringVal.equals("0000-00-00 00:00:00") || stringVal.equals("00000000000000") || stringVal.equals("0"))) {
                this.wasNullFlag = true;
                return null;
            }
            if (this.fields[columnIndex - 1].getMysqlType() == 7) {
                switch (length) {
                    case 8: 
                    case 14: {
                        year = new Integer(stringVal.substring(0, 4));
                        month = new Integer(stringVal.substring(4, 6));
                        day = new Integer(stringVal.substring(6, 8));
                        return this.fastDateCreate(cal, year - 1900, month - 1, day);
                    }
                    case 6: 
                    case 10: 
                    case 12: {
                        year = new Integer(stringVal.substring(0, 2));
                        if (year <= 69) {
                            year = new Integer(year + 100);
                        }
                        month = new Integer(stringVal.substring(2, 4));
                        day = new Integer(stringVal.substring(4, 6));
                        return this.fastDateCreate(cal, year, month - 1, day);
                    }
                    case 4: {
                        year = new Integer(stringVal.substring(0, 4));
                        if (year <= 69) {
                            year = new Integer(year + 100);
                        }
                        month = new Integer(stringVal.substring(2, 4));
                        return this.fastDateCreate(cal, year, month - 1, 1);
                    }
                    case 2: {
                        year = new Integer(stringVal.substring(0, 2));
                        if (year <= 69) {
                            year = new Integer(year + 100);
                        }
                        return this.fastDateCreate(cal, year, 0, 1);
                    }
                }
                throw new SQLException("Bad format for Date '" + stringVal + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
            }
            if (this.fields[columnIndex - 1].getMysqlType() == 13) {
                year = new Integer(stringVal.substring(0, 4));
                return this.fastDateCreate(cal, year - 1900, 0, 1);
            }
            if (length < 10) {
                throw new SQLException("Bad format for Date '" + stringVal + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
            }
            year = new Integer(stringVal.substring(0, 4));
            month = new Integer(stringVal.substring(5, 7));
            day = new Integer(stringVal.substring(8, 10));
            return this.fastDateCreate(cal, year - 1900, month - 1, day);
        }
        catch (Exception e2) {
            throw new SQLException("Cannot convert value '" + stringVal + "' from column " + columnIndex + "(" + stringVal + " ) to DATE.", "S1009");
        }
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(columnName);
    }

    public double getDouble(int columnIndex) throws SQLException {
        try {
            return this.getDoubleInternal(columnIndex);
        }
        catch (NumberFormatException E) {
            throw new SQLException("Bad format for number '" + new String(this.thisRow[columnIndex - 1]) + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
        }
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("Illegal value for fetch direction", "S1009");
        }
        this.fetchDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("Value must be between 0 and getMaxRows()", "S1009");
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public boolean isFirst() throws SQLException {
        boolean b2 = this.rowData.isFirst();
        return b2;
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.checkRowPos();
        String val = null;
        try {
            val = this.getString(columnIndex);
            if (val != null && val.length() != 0) {
                float f2 = Float.parseFloat(val);
                return f2;
            }
            return 0.0f;
        }
        catch (NumberFormatException nfe) {
            try {
                return (float)Double.parseDouble(val);
            }
            catch (NumberFormatException newNfe) {
                throw new SQLException("Invalid value for getFloat() - '" + val + "'", "S1009");
            }
        }
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public int getInt(int columnIndex) throws SQLException {
        String val = null;
        try {
            val = this.getString(columnIndex);
            if (val != null && val.length() != 0) {
                if (val.indexOf("e") == -1 && val.indexOf("E") == -1 && val.indexOf(".") == -1) {
                    return Integer.parseInt(val);
                }
                return (int)Double.parseDouble(val);
            }
            return 0;
        }
        catch (NumberFormatException nfe) {
            try {
                return (int)Double.parseDouble(val);
            }
            catch (NumberFormatException newNfe) {
                throw new SQLException("Invalid value for getInt() - '" + val + "'", "S1009");
            }
        }
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public boolean isLast() throws SQLException {
        boolean b2 = this.rowData.isLast();
        return b2;
    }

    public long getLong(int columnIndex) throws SQLException {
        this.checkRowPos();
        String val = null;
        try {
            val = this.getString(columnIndex);
            if (val != null && val.length() != 0) {
                if (val.indexOf("e") == -1 && val.indexOf("E") == -1) {
                    return Long.parseLong(val);
                }
                return Double.doubleToLongBits(Double.parseDouble(val));
            }
            return 0L;
        }
        catch (NumberFormatException nfe) {
            try {
                return (long)Double.parseDouble(val);
            }
            catch (NumberFormatException newNfe) {
                throw new SQLException("Invalid value for getLong() - '" + val + "'", "S1009");
            }
        }
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.fields);
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.checkRowPos();
        try {
            if (this.thisRow[columnIndex - 1] == null) {
                this.wasNullFlag = true;
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobEx) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.fields.length + ").", "S1002");
        }
        this.wasNullFlag = false;
        Field field = this.fields[columnIndex - 1];
        switch (field.getSQLType()) {
            case -7: {
                return this.getBoolean(columnIndex);
            }
            case -6: {
                return new Integer(this.getInt(columnIndex));
            }
            case 5: {
                return new Integer(this.getInt(columnIndex));
            }
            case 4: {
                if (field.isUnsigned()) {
                    return new Long(this.getLong(columnIndex));
                }
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                if (field.isUnsigned()) {
                    return this.getBigDecimal(columnIndex);
                }
                return new Long(this.getLong(columnIndex));
            }
            case 2: 
            case 3: {
                String stringVal = this.getString(columnIndex);
                if (stringVal != null) {
                    BigDecimal val2;
                    if (stringVal.length() == 0) {
                        BigDecimal val2 = new BigDecimal(0.0);
                        return val2;
                    }
                    try {
                        val2 = new BigDecimal(stringVal);
                    }
                    catch (NumberFormatException ex) {
                        throw new SQLException("Bad format for BigDecimal '" + stringVal + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
                    }
                    return val2;
                }
                return null;
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] data;
                if (!field.isBlob()) {
                    return this.getString(columnIndex);
                }
                if (!field.isBinary()) {
                    return this.getString(columnIndex);
                }
                Object obj = data = this.getBytes(columnIndex);
                if (data != null && data.length >= 2 && data[0] == -84 && data[1] == -19) {
                    try {
                        ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
                        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
                        obj = objIn.readObject();
                        objIn.close();
                        bytesIn.close();
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new SQLException("Class not found: " + cnfe.toString() + " while reading serialized object");
                    }
                    catch (IOException ex) {
                        obj = data;
                    }
                }
                return obj;
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
        }
        return this.getString(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(int i2, Map map) throws SQLException {
        return this.getObject(i2);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    public Ref getRef(int i2) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(String colName) throws SQLException {
        throw new NotImplemented();
    }

    public int getRow() throws SQLException {
        int currentRow = this.rowData.getCurrentRowNumber();
        int row = 0;
        row = !this.rowData.isDynamic() ? (currentRow < 0 || this.rowData.isAfterLast() || this.rowData.isEmpty() ? 0 : currentRow + 1) : currentRow + 1;
        return row;
    }

    public short getShort(int columnIndex) throws SQLException {
        this.checkRowPos();
        String val = null;
        try {
            val = this.getString(columnIndex);
            if (val != null && val.length() != 0) {
                if (val.indexOf("e") == -1 && val.indexOf("E") == -1 && val.indexOf(".") == -1) {
                    return Short.parseShort(val);
                }
                return (short)Double.parseDouble(val);
            }
            return 0;
        }
        catch (NumberFormatException nfe) {
            try {
                return (short)Double.parseDouble(val);
            }
            catch (NumberFormatException newNfe) {
                throw new SQLException("Invalid value for getShort() - '" + val + "'", "S1009");
            }
        }
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public java.sql.Statement getStatement() throws SQLException {
        return this.owningStatement;
    }

    public String getString(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (this.fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        try {
            if (this.thisRow[columnIndex - 1] == null) {
                this.wasNullFlag = true;
                return null;
            }
            this.wasNullFlag = false;
        }
        catch (NullPointerException E) {
            this.wasNullFlag = true;
            return null;
        }
        catch (ArrayIndexOutOfBoundsException aioobEx) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.fields.length + ").", "S1002");
        }
        String stringVal = null;
        --columnIndex;
        if (this.connection != null && this.connection.useUnicode()) {
            try {
                String encoding = this.fields[columnIndex].getCharacterSet();
                if (encoding == null) {
                    stringVal = new String(this.thisRow[columnIndex]);
                }
                SingleByteCharsetConverter converter = this.connection.getCharsetConverter(encoding);
                if (converter != null) {
                    stringVal = converter.toString(this.thisRow[columnIndex]);
                }
                stringVal = new String(this.thisRow[columnIndex], encoding);
            }
            catch (UnsupportedEncodingException E) {
                throw new SQLException("Unsupported character encoding '" + this.connection.getEncoding() + "'.", "S1000");
            }
        } else {
            stringVal = StringUtils.toAsciiString(this.thisRow[columnIndex]);
        }
        return stringVal;
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        return this.getTimeInternal(columnIndex, this.defaultTimeZone);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimeInternal(columnIndex, cal.getTimeZone());
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestampInternal(columnIndex, this.defaultTimeZone);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestampInternal(columnIndex, cal.getTimeZone());
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public int getType() throws SQLException {
        return this.resultSetType;
    }

    public URL getURL(int colIndex) throws SQLException {
        String val = this.getString(colIndex);
        if (val == null) {
            return null;
        }
        try {
            return new URL(val);
        }
        catch (MalformedURLException mfe) {
            throw new SQLException("Malformed URL '" + val + "'", "S1009");
        }
    }

    public URL getURL(String colName) throws SQLException {
        String val = this.getString(colName);
        if (val == null) {
            return null;
        }
        try {
            return new URL(val);
        }
        catch (MalformedURLException mfe) {
            throw new SQLException("Malformed URL '" + val + "'", "S1009");
        }
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    public boolean absolute(int row) throws SQLException {
        boolean b2;
        this.checkClosed();
        if (this.rowData.size() == 0) {
            b2 = false;
        } else {
            if (row == 0) {
                throw new SQLException("Cannot absolute position to row 0", "S1009");
            }
            if (this.onInsertRow) {
                this.onInsertRow = false;
            }
            if (this.doingUpdates) {
                this.doingUpdates = false;
            }
            if (row == 1) {
                b2 = this.first();
            } else if (row == -1) {
                b2 = this.last();
            } else if (row > this.rowData.size()) {
                this.afterLast();
                b2 = false;
            } else if (row < 0) {
                int newRowPosition = this.rowData.size() + row + 1;
                if (newRowPosition <= 0) {
                    this.beforeFirst();
                    b2 = false;
                } else {
                    b2 = this.absolute(newRowPosition);
                }
            } else {
                this.rowData.setCurrentRow(--row);
                this.thisRow = this.rowData.getAt(row);
                b2 = true;
            }
        }
        return b2;
    }

    public void afterLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        if (this.rowData.size() != 0) {
            this.rowData.afterLast();
            this.thisRow = null;
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        if (this.rowData.size() == 0) {
            return;
        }
        this.rowData.beforeFirst();
        this.thisRow = null;
    }

    public void cancelRowUpdates() throws SQLException {
        throw new NotUpdatable();
    }

    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public void close() throws SQLException {
        this.realClose(true);
    }

    public void deleteRow() throws SQLException {
        throw new NotUpdatable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String columnName) throws SQLException {
        ResultSet resultSet = this;
        synchronized (resultSet) {
            if (!this.hasBuiltIndexMapping) {
                this.buildIndexMapping();
            }
        }
        Integer index = (Integer)this.columnNameToIndex.get(columnName);
        if (index == null) {
            index = (Integer)this.fullColumnNameToIndex.get(columnName);
        }
        if (index != null) {
            return index + 1;
        }
        String columnNameUC = columnName.toUpperCase();
        int i2 = 0;
        while (i2 < this.fields.length) {
            if (this.fields[i2].getName().toUpperCase().equals(columnNameUC)) {
                return i2 + 1;
            }
            if (this.fields[i2].getFullName().toUpperCase().equals(columnNameUC)) {
                return i2 + 1;
            }
            ++i2;
        }
        throw new SQLException("Column '" + columnName + "' not found.", "S0022");
    }

    public boolean first() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.rowData.isEmpty()) {
            return false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        this.rowData.beforeFirst();
        this.thisRow = this.rowData.next();
        return true;
    }

    public void insertRow() throws SQLException {
        throw new NotUpdatable();
    }

    public boolean last() throws SQLException {
        this.checkClosed();
        if (this.rowData.size() == 0) {
            return false;
        }
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        this.rowData.beforeLast();
        this.thisRow = this.rowData.next();
        return true;
    }

    public void moveToCurrentRow() throws SQLException {
        throw new NotUpdatable();
    }

    public void moveToInsertRow() throws SQLException {
        throw new NotUpdatable();
    }

    public boolean next() throws SQLException {
        boolean b2;
        this.checkClosed();
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        if (!this.reallyResult()) {
            throw new SQLException("ResultSet is from UPDATE. No Data", "S1000");
        }
        if (this.rowData.size() == 0) {
            b2 = false;
        } else if (!this.rowData.hasNext()) {
            this.rowData.next();
            b2 = false;
        } else {
            this.clearWarnings();
            this.thisRow = this.rowData.next();
            b2 = true;
        }
        return b2;
    }

    public boolean prev() throws SQLException {
        this.checkClosed();
        int rowIndex = this.rowData.getCurrentRowNumber();
        if (rowIndex - 1 >= 0) {
            this.rowData.setCurrentRow(--rowIndex);
            this.thisRow = this.rowData.getAt(rowIndex);
            return true;
        }
        if (rowIndex - 1 == -1) {
            this.rowData.setCurrentRow(--rowIndex);
            this.thisRow = null;
            return false;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        return this.prev();
    }

    public void refreshRow() throws SQLException {
        throw new NotUpdatable();
    }

    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        if (this.rowData.size() == 0) {
            return false;
        }
        this.rowData.moveRowRelative(rows);
        this.thisRow = this.rowData.getAt(this.rowData.getCurrentRowNumber());
        boolean b2 = !this.rowData.isAfterLast() && !this.rowData.isBeforeFirst();
        return b2;
    }

    public boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateAsciiStream(int columnIndex, InputStream x2, int length) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateAsciiStream(String columnName, InputStream x2, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x2, length);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBigDecimal(String columnName, BigDecimal x2) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x2);
    }

    public void updateBinaryStream(int columnIndex, InputStream x2, int length) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBinaryStream(String columnName, InputStream x2, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x2, length);
    }

    public void updateBlob(int arg0, java.sql.Blob arg1) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBlob(String arg0, java.sql.Blob arg1) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBoolean(int columnIndex, boolean x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBoolean(String columnName, boolean x2) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x2);
    }

    public void updateByte(int columnIndex, byte x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateByte(String columnName, byte x2) throws SQLException {
        this.updateByte(this.findColumn(columnName), x2);
    }

    public void updateBytes(int columnIndex, byte[] x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBytes(String columnName, byte[] x2) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x2);
    }

    public void updateCharacterStream(int columnIndex, Reader x2, int length) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateClob(int arg0, java.sql.Clob arg1) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateClob(String columnName, java.sql.Clob clob) throws SQLException {
        this.updateClob(this.findColumn(columnName), clob);
    }

    public void updateDate(int columnIndex, Date x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateDate(String columnName, Date x2) throws SQLException {
        this.updateDate(this.findColumn(columnName), x2);
    }

    public void updateDouble(int columnIndex, double x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateDouble(String columnName, double x2) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x2);
    }

    public void updateFloat(int columnIndex, float x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateFloat(String columnName, float x2) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x2);
    }

    public void updateInt(int columnIndex, int x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateInt(String columnName, int x2) throws SQLException {
        this.updateInt(this.findColumn(columnName), x2);
    }

    public void updateLong(int columnIndex, long x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateLong(String columnName, long x2) throws SQLException {
        this.updateLong(this.findColumn(columnName), x2);
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateObject(int columnIndex, Object x2, int scale) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateObject(int columnIndex, Object x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateObject(String columnName, Object x2, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x2);
    }

    public void updateObject(String columnName, Object x2) throws SQLException {
        this.updateObject(this.findColumn(columnName), x2);
    }

    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateRow() throws SQLException {
        throw new NotUpdatable();
    }

    public void updateShort(int columnIndex, short x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateShort(String columnName, short x2) throws SQLException {
        this.updateShort(this.findColumn(columnName), x2);
    }

    public void updateString(int columnIndex, String x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateString(String columnName, String x2) throws SQLException {
        this.updateString(this.findColumn(columnName), x2);
    }

    public void updateTime(int columnIndex, Time x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateTime(String columnName, Time x2) throws SQLException {
        this.updateTime(this.findColumn(columnName), x2);
    }

    public void updateTimestamp(int columnIndex, Timestamp x2) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateTimestamp(String columnName, Timestamp x2) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x2);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    protected double getDoubleInternal(int colIndex) throws SQLException {
        String s2 = "";
        try {
            s2 = this.getString(colIndex);
            if (s2 == null || s2.length() == 0) {
                return 0.0;
            }
            double d2 = Double.parseDouble(s2);
            if (this.useStrictFloatingPoint) {
                if (d2 == 2.147483648E9) {
                    d2 = 2.147483647E9;
                } else if (d2 == 1.0000000036275E-15) {
                    d2 = 1.0E-15;
                } else if (d2 == 9.999999869911E14) {
                    d2 = 9.99999999999999E14;
                } else if (d2 == 1.4012984643248E-45) {
                    d2 = 1.4E-45;
                } else if (d2 == 1.4013E-45) {
                    d2 = 1.4E-45;
                } else if (d2 == 3.4028234663853E37) {
                    d2 = 3.4028235E37;
                } else if (d2 == -2.14748E9) {
                    d2 = -2.147483648E9;
                } else if (d2 == 3.40282E37) {
                    d2 = 3.4028235E37;
                }
            }
            return d2;
        }
        catch (NumberFormatException e2) {
            throw new SQLException("Bad format for number '" + s2 + "'");
        }
    }

    protected void setFirstCharOfQuery(char c2) {
        this.firstCharOfQuery = c2;
    }

    protected char getFirstCharOfQuery() {
        return this.firstCharOfQuery;
    }

    protected void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    protected void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    protected void setServerInfo(String info) {
        this.serverInfo = info;
    }

    protected String getServerInfo() {
        return this.serverInfo;
    }

    protected void buildIndexMapping() {
        int numFields = this.fields.length;
        this.columnNameToIndex = new HashMap();
        this.fullColumnNameToIndex = new HashMap();
        int i2 = numFields - 1;
        while (i2 >= 0) {
            Integer index = new Integer(i2);
            String columnName = this.fields[i2].getName();
            String fullColumnName = this.fields[i2].getFullName();
            if (columnName != null) {
                this.columnNameToIndex.put(columnName, index);
                this.columnNameToIndex.put(columnName.toUpperCase(), index);
                this.columnNameToIndex.put(columnName.toLowerCase(), index);
            }
            if (fullColumnName != null) {
                this.fullColumnNameToIndex.put(fullColumnName, index);
                this.fullColumnNameToIndex.put(fullColumnName.toUpperCase(), index);
                this.fullColumnNameToIndex.put(fullColumnName.toLowerCase(), index);
            }
            --i2;
        }
        this.hasBuiltIndexMapping = true;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Operation not allowed after ResultSet closed", "S1000");
        }
    }

    protected void checkRowPos() throws SQLException {
        this.checkClosed();
        if (!this.rowData.isDynamic() && this.rowData.size() == 0) {
            throw new SQLException("Illegal operation on empty result set", "S1000");
        }
        if (this.rowData.isBeforeFirst()) {
            throw new SQLException("Before start of result set", "S1000");
        }
        if (this.rowData.isAfterLast()) {
            throw new SQLException("After end of result set", "S1000");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realClose(boolean closeRowData) throws SQLException {
        try {
            if (closeRowData && this.rowData != null) {
                this.rowData.close();
            }
            Object var3_2 = null;
            this.defaultTimeZone = null;
            this.rowData = null;
            this.isClosed = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.defaultTimeZone = null;
            this.rowData = null;
            this.isClosed = true;
            throw throwable;
        }
    }

    void setStatement(Statement stmt) {
        this.owningStatement = stmt;
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    long getUpdateID() {
        return this.updateId;
    }

    boolean reallyResult() {
        return this.reallyResult;
    }

    private Time getTimeInternal(int columnIndex, TimeZone tz) throws SQLException {
        int hr = 0;
        int min = 0;
        int sec = 0;
        try {
            String timeAsString = this.getString(columnIndex);
            if (timeAsString == null) {
                return null;
            }
            int length = timeAsString.length();
            if (length > 0 && timeAsString.charAt(0) == '0' && (timeAsString.equals("0000-00-00") || timeAsString.equals("0000-00-00 00:00:00") || timeAsString.equals("00000000000000"))) {
                this.wasNullFlag = true;
                return null;
            }
            Field timeColField = this.fields[columnIndex - 1];
            if (timeColField.getMysqlType() == 7) {
                switch (length) {
                    case 12: 
                    case 14: {
                        hr = Integer.parseInt(timeAsString.substring(length - 6, length - 4));
                        min = Integer.parseInt(timeAsString.substring(length - 4, length - 2));
                        sec = Integer.parseInt(timeAsString.substring(length - 2, length));
                        break;
                    }
                    case 10: {
                        hr = Integer.parseInt(timeAsString.substring(6, 8));
                        min = Integer.parseInt(timeAsString.substring(8, 10));
                        sec = 0;
                        break;
                    }
                    default: {
                        throw new SQLException("Timestamp too small to convert to Time value in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
                    }
                }
                SQLWarning precisionLost = new SQLWarning("Precision lost converting TIMESTAMP to Time with getTime() on column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").");
                if (this.warningChain == null) {
                    this.warningChain = precisionLost;
                } else {
                    this.warningChain.setNextWarning(precisionLost);
                }
            } else if (timeColField.getMysqlType() == 12) {
                hr = Integer.parseInt(timeAsString.substring(11, 13));
                min = Integer.parseInt(timeAsString.substring(14, 16));
                sec = Integer.parseInt(timeAsString.substring(17, 19));
                SQLWarning precisionLost = new SQLWarning("Precision lost converting DATETIME to Time with getTime() on column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").");
                if (this.warningChain == null) {
                    this.warningChain = precisionLost;
                } else {
                    this.warningChain.setNextWarning(precisionLost);
                }
            } else {
                if (length != 5 && length != 8) {
                    throw new SQLException("Bad format for Time '" + timeAsString + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
                }
                hr = Integer.parseInt(timeAsString.substring(0, 2));
                min = Integer.parseInt(timeAsString.substring(3, 5));
                sec = length == 5 ? 0 : Integer.parseInt(timeAsString.substring(6));
            }
            return TimeUtil.changeTimezone(this.connection, this.fastTimeCreate(null, hr, min, sec), this.connection.getServerTimezone(), tz);
        }
        catch (Exception ex) {
            throw new SQLException(ex.getClass().getName(), "S1009");
        }
    }

    private Timestamp getTimestampInternal(int columnIndex, TimeZone tz) throws SQLException {
        String timestampValue = this.getString(columnIndex);
        try {
            if (timestampValue == null) {
                return null;
            }
            int length = timestampValue.length();
            if (length > 0 && timestampValue.charAt(0) == '0' && (timestampValue.equals("0000-00-00") || timestampValue.equals("0000-00-00 00:00:00") || timestampValue.equals("00000000000000") || timestampValue.equals("0"))) {
                this.wasNullFlag = true;
                return null;
            }
            if (this.fields[columnIndex - 1].getMysqlType() == 13) {
                return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, Integer.parseInt(timestampValue.substring(0, 4)) - 1900, 0, 1, 0, 0, 0, 0), this.connection.getServerTimezone(), tz);
            }
            switch (length) {
                case 19: {
                    int year = Integer.parseInt(timestampValue.substring(0, 4));
                    int month = Integer.parseInt(timestampValue.substring(5, 7));
                    int day = Integer.parseInt(timestampValue.substring(8, 10));
                    int hour = Integer.parseInt(timestampValue.substring(11, 13));
                    int minutes = Integer.parseInt(timestampValue.substring(14, 16));
                    int seconds = Integer.parseInt(timestampValue.substring(17, 19));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year - 1900, month - 1, day, hour, minutes, seconds, 0), this.connection.getServerTimezone(), tz);
                }
                case 14: {
                    int year = Integer.parseInt(timestampValue.substring(0, 4));
                    int month = Integer.parseInt(timestampValue.substring(4, 6));
                    int day = Integer.parseInt(timestampValue.substring(6, 8));
                    int hour = Integer.parseInt(timestampValue.substring(8, 10));
                    int minutes = Integer.parseInt(timestampValue.substring(10, 12));
                    int seconds = Integer.parseInt(timestampValue.substring(12, 14));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year - 1900, month - 1, day, hour, minutes, seconds, 0), this.connection.getServerTimezone(), tz);
                }
                case 12: {
                    int year = Integer.parseInt(timestampValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    int month = Integer.parseInt(timestampValue.substring(2, 4));
                    int day = Integer.parseInt(timestampValue.substring(4, 6));
                    int hour = Integer.parseInt(timestampValue.substring(6, 8));
                    int minutes = Integer.parseInt(timestampValue.substring(8, 10));
                    int seconds = Integer.parseInt(timestampValue.substring(10, 12));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year, month - 1, day, hour, minutes, seconds, 0), this.connection.getServerTimezone(), tz);
                }
                case 10: {
                    int minutes;
                    int hour;
                    int day;
                    int month;
                    int year;
                    if (this.fields[columnIndex - 1].getMysqlType() == 10 || timestampValue.indexOf("-") != -1) {
                        year = Integer.parseInt(timestampValue.substring(0, 4)) - 1900;
                        month = Integer.parseInt(timestampValue.substring(5, 7));
                        day = Integer.parseInt(timestampValue.substring(8, 10));
                        hour = 0;
                        minutes = 0;
                    } else {
                        year = Integer.parseInt(timestampValue.substring(0, 2));
                        if (year <= 69) {
                            year += 100;
                        }
                        month = Integer.parseInt(timestampValue.substring(2, 4));
                        day = Integer.parseInt(timestampValue.substring(4, 6));
                        hour = Integer.parseInt(timestampValue.substring(6, 8));
                        minutes = Integer.parseInt(timestampValue.substring(8, 10));
                    }
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year, month - 1, day, hour, minutes, 0, 0), this.connection.getServerTimezone(), tz);
                }
                case 8: {
                    int year = Integer.parseInt(timestampValue.substring(0, 4));
                    int month = Integer.parseInt(timestampValue.substring(4, 6));
                    int day = Integer.parseInt(timestampValue.substring(6, 8));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year - 1900, month - 1, day, 0, 0, 0, 0), this.connection.getServerTimezone(), tz);
                }
                case 6: {
                    int year = Integer.parseInt(timestampValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    int month = Integer.parseInt(timestampValue.substring(2, 4));
                    int day = Integer.parseInt(timestampValue.substring(4, 6));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year, month - 1, day, 0, 0, 0, 0), this.connection.getServerTimezone(), tz);
                }
                case 4: {
                    int year = Integer.parseInt(timestampValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    int month = Integer.parseInt(timestampValue.substring(2, 4));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year, month - 1, 1, 0, 0, 0, 0), this.connection.getServerTimezone(), tz);
                }
                case 2: {
                    int year = Integer.parseInt(timestampValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year, 0, 1, 0, 0, 0, 0), this.connection.getServerTimezone(), tz);
                }
            }
            throw new SQLException("Bad format for Timestamp '" + timestampValue + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
        }
        catch (Exception e2) {
            throw new SQLException("Cannot convert value '" + timestampValue + "' from column " + columnIndex + "(" + timestampValue + " ) to TIMESTAMP.", "S1009");
        }
    }

    private synchronized Date fastDateCreate(Calendar cal, int year, int month, int day) {
        if (cal == null) {
            if (this.fastDateCal == null) {
                this.fastDateCal = new GregorianCalendar();
                this.fastDateCal.setTimeZone(this.defaultTimeZone);
            }
            cal = this.fastDateCal;
        }
        cal.clear();
        cal.set(year + 1900, month, day, 0, 0, 0);
        long dateAsMillis = 0L;
        try {
            dateAsMillis = cal.getTimeInMillis();
        }
        catch (IllegalAccessError iae) {
            dateAsMillis = cal.getTime().getTime();
        }
        return new Date(dateAsMillis);
    }

    private synchronized Time fastTimeCreate(Calendar cal, int hour, int minute, int second) {
        if (cal == null) {
            if (this.fastDateCal == null) {
                this.fastDateCal = new GregorianCalendar();
                this.fastDateCal.setTimeZone(this.defaultTimeZone);
            }
            cal = this.fastDateCal;
        }
        cal.clear();
        cal.set(1970, 0, 1, hour, minute, second);
        long timeAsMillis = 0L;
        try {
            timeAsMillis = cal.getTimeInMillis();
        }
        catch (IllegalAccessError iae) {
            timeAsMillis = cal.getTime().getTime();
        }
        return new Time(timeAsMillis);
    }

    private synchronized Timestamp fastTimestampCreate(Calendar cal, int year, int month, int day, int hour, int minute, int seconds, int secondsPart) {
        if (cal == null) {
            if (this.fastDateCal == null) {
                this.fastDateCal = new GregorianCalendar();
                this.fastDateCal.setTimeZone(this.defaultTimeZone);
            }
            cal = this.fastDateCal;
        }
        cal.clear();
        cal.set(year + 1900, month, day, hour, minute, seconds);
        long tsAsMillis = 0L;
        try {
            tsAsMillis = cal.getTimeInMillis();
        }
        catch (IllegalAccessError iae) {
            tsAsMillis = cal.getTime().getTime();
        }
        Timestamp ts = new Timestamp(tsAsMillis);
        ts.setNanos(secondsPart);
        return ts;
    }
}

