/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.CannotAccessLocalSource;
import com.vmware.vim25.InvalidLicense;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.KeyValue;
import com.vmware.vim25.LicenseAvailabilityInfo;
import com.vmware.vim25.LicenseDiagnostics;
import com.vmware.vim25.LicenseFeatureInfo;
import com.vmware.vim25.LicenseManagerEvaluationInfo;
import com.vmware.vim25.LicenseManagerLicenseInfo;
import com.vmware.vim25.LicenseServerUnavailable;
import com.vmware.vim25.LicenseSource;
import com.vmware.vim25.LicenseUsageInfo;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.LicenseAssignmentManager;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class LicenseManager
extends ManagedObject {
    public LicenseManager(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public LicenseDiagnostics getDiagnostics() {
        return (LicenseDiagnostics)this.getCurrentProperty("diagnostics");
    }

    public LicenseManagerEvaluationInfo getEvaluation() {
        return (LicenseManagerEvaluationInfo)this.getCurrentProperty("evaluation");
    }

    public LicenseAssignmentManager getLicenseAssignmentManager() {
        return (LicenseAssignmentManager)this.getManagedObject("licenseAssignmentManager");
    }

    public LicenseManagerLicenseInfo[] getLicenses() {
        return (LicenseManagerLicenseInfo[])this.getCurrentProperty("licenses");
    }

    public LicenseFeatureInfo[] getFeatureInfo() {
        return (LicenseFeatureInfo[])this.getCurrentProperty("featureInfo");
    }

    public String getLicensedEdition() {
        return (String)this.getCurrentProperty("licensedEdition");
    }

    public LicenseSource getSource() {
        return (LicenseSource)this.getCurrentProperty("source");
    }

    public boolean getSourceAvailable() {
        return (Boolean)this.getCurrentProperty("sourceAvailable");
    }

    public LicenseManagerLicenseInfo addLicense(String licenseKey, KeyValue[] labels) throws RuntimeFault, RemoteException {
        return this.getVimService().addLicense(this.getMOR(), licenseKey, labels);
    }

    public LicenseManagerLicenseInfo decodeLicense(String licenseKey) throws RuntimeFault, RemoteException {
        return this.getVimService().decodeLicense(this.getMOR(), licenseKey);
    }

    public boolean checkLicenseFeature(HostSystem host, String featureKey) throws InvalidState, RuntimeFault, RemoteException {
        return this.getVimService().checkLicenseFeature(this.getMOR(), host == null ? null : host.getMOR(), featureKey);
    }

    public void configureLicenseSource(HostSystem host, LicenseSource licenseSource) throws CannotAccessLocalSource, LicenseServerUnavailable, InvalidLicense, RuntimeFault, RemoteException {
        this.getVimService().configureLicenseSource(this.getMOR(), host == null ? null : host.getMOR(), licenseSource);
    }

    public void disableFeature(HostSystem host, String featureKey) throws LicenseServerUnavailable, InvalidState, RuntimeFault, RemoteException {
        this.getVimService().disableFeature(this.getMOR(), host == null ? null : host.getMOR(), featureKey);
    }

    public void enableFeature(HostSystem host, String featureKey) throws LicenseServerUnavailable, InvalidState, RuntimeFault, RemoteException {
        this.getVimService().enableFeature(this.getMOR(), host == null ? null : host.getMOR(), featureKey);
    }

    public LicenseAvailabilityInfo[] queryLicenseSourceAvailability(HostSystem host) throws RuntimeFault, RemoteException {
        return this.getVimService().queryLicenseSourceAvailability(this.getMOR(), host == null ? null : host.getMOR());
    }

    public LicenseUsageInfo queryLicenseUsage(HostSystem host) throws RuntimeFault, RemoteException {
        return this.getVimService().queryLicenseUsage(this.getMOR(), host == null ? null : host.getMOR());
    }

    public LicenseFeatureInfo[] querySupportedFeatures(HostSystem host) throws RuntimeFault, RemoteException {
        return this.getVimService().querySupportedFeatures(this.getMOR(), host == null ? null : host.getMOR());
    }

    public void removeLicense(String licenseKey) throws RuntimeFault, RemoteException {
        this.getVimService().removeLicense(this.getMOR(), licenseKey);
    }

    public void removeLicenseLabel(String licenseKey, String labelKey) throws RuntimeFault, RemoteException {
        this.getVimService().removeLicenseLabel(this.getMOR(), licenseKey, labelKey);
    }

    public void updateLicense(String licenseKey, KeyValue[] labels) throws RuntimeFault, RemoteException {
        this.getVimService().updateLicense(this.getMOR(), licenseKey, labels);
    }

    public void updateLicenseLabel(String licenseKey, String labelKey, String labelValue) throws RuntimeFault, RemoteException {
        this.getVimService().updateLicenseLabel(this.getMOR(), licenseKey, labelKey, labelValue);
    }

    public void setLicenseEdition(HostSystem host, String featureKey) throws LicenseServerUnavailable, InvalidState, RuntimeFault, RemoteException {
        this.getVimService().setLicenseEdition(this.getMOR(), host == null ? null : host.getMOR(), featureKey);
    }
}

