/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.GB18030;

public class CharToByteGB18030
extends CharToByteConverter {
    private char highHalfZoneCode;
    boolean flushed = true;
    private static final int GB18030_SINGLE_BYTE = 1;
    private static final int GB18030_DOUBLE_BYTE = 2;
    private static final int GB18030_FOUR_BYTE = 3;
    private static short[] index1;
    private static String[] index2;
    private int currentState;

    public CharToByteGB18030() {
        GB18030 gB18030 = new GB18030();
        this.currentState = 2;
        this.subBytes = new byte[1];
        this.subBytes[0] = 63;
        index1 = gB18030.getEncoderIndex1();
        index2 = gB18030.getEncoderIndex2();
    }

    public int flush(byte[] byArray, int n, int n2) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        this.flushed = true;
        return 0;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.currentState = 2;
    }

    public boolean canConvert(char c) {
        return (c < '\ud800' || c > '\udfff') && c < '\ufffe';
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        this.charOff = n;
        this.byteOff = n3;
        this.flushed = false;
        if (this.highHalfZoneCode != '\u0000') {
            if (cArray[n] >= '\udc00' && cArray[n] <= '\udfff') {
                char[] cArray2 = new char[n2 - n + 1];
                cArray2[0] = this.highHalfZoneCode;
                System.arraycopy(cArray, n, cArray2, 1, n2 - n);
                --this.charOff;
                cArray = cArray2;
                n = 0;
                n2 = cArray2.length;
                this.highHalfZoneCode = '\u0000';
            } else {
                this.badInputLength = 0;
                throw new MalformedInputException();
            }
        }
        while (this.charOff < n2) {
            block25: {
                char c;
                if ((c = cArray[this.charOff++]) >= '\ud800' && c <= '\udbff') {
                    if (this.charOff + 1 > n2) {
                        this.highHalfZoneCode = c;
                        return this.byteOff - n3;
                    }
                    char c2 = c;
                    c = cArray[this.charOff];
                    if (c >= '\udc00' && c <= '\udfff') {
                        int n8 = 2;
                        ++this.charOff;
                        n5 = (c2 - 55296) * 1024 + (c - 56320) + 189000;
                        this.currentState = 3;
                        break block25;
                    } else {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                }
                if (c >= '\udc00' && c <= '\udfff') {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                if (c >= '\u0000' && c <= '\u007f') {
                    if (this.byteOff >= n4) {
                        throw new ConversionBufferFullException();
                    }
                    this.currentState = 1;
                    byArray[this.byteOff++] = (byte)c;
                } else if (c <= '\ua4c6' || c >= '\ue000') {
                    int n9 = this.getGB18030(index1, index2, c);
                    if (n9 == 65533) {
                        if (!this.subMode) {
                            this.badInputLength = 1;
                            throw new UnknownCharacterException();
                        }
                        if (this.byteOff >= n4) {
                            throw new ConversionBufferFullException();
                        }
                        byArray[this.byteOff++] = this.subBytes[0];
                        continue;
                    }
                    n6 = (n9 & 0xFF00) >> 8;
                    n7 = n9 & 0xFF;
                    n5 = (n6 - 32) * 256 + n7;
                    if (c >= '\ue000' && c < '\uf900') {
                        n5 += 33469;
                    } else if (c >= '\uf900') {
                        n5 += 37801;
                    }
                    this.currentState = n6 > 128 ? 2 : 3;
                } else if (c >= '\ua4c7' && c <= '\ud7ff') {
                    n5 = c - 21827;
                    this.currentState = 3;
                } else {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
            }
            if (this.currentState == 1) continue;
            if (this.currentState == 2) {
                if (this.byteOff + 2 > n4) {
                    throw new ConversionBufferFullException();
                }
                byArray[this.byteOff++] = (byte)n6;
                byArray[this.byteOff++] = (byte)n7;
                continue;
            }
            if (this.byteOff + 4 > n4) {
                throw new ConversionBufferFullException();
            }
            byte by = (byte)(n5 % 10 + 48);
            byte by2 = (byte)((n5 /= 10) % 126 + 129);
            byte by3 = (byte)((n5 /= 126) % 10 + 48);
            byte by4 = (byte)(n5 / 10 + 129);
            byArray[this.byteOff++] = by4;
            byArray[this.byteOff++] = by3;
            byArray[this.byteOff++] = by2;
            byArray[this.byteOff++] = by;
        }
        return this.byteOff - n3;
    }

    public int getMaxBytesPerChar() {
        return 4;
    }

    public String getCharacterEncoding() {
        return "GB18030";
    }

    private int getGB18030(short[] sArray, String[] stringArray, char c) {
        int n = sArray[(c & 0xFF00) >> 8] << 8;
        return stringArray[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
    }
}

